IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'EST_PED_VD_ENVIO_PENDENTE')
BEGIN
	CREATE TABLE [dbo].[EST_PED_VD_ENVIO_PENDENTE](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_PED] [int] NOT NULL,
		[STATUS] [int] NOT NULL,
	 CONSTRAINT [PK_EST_PED_VD_ENVIO_PENDENTE_1] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_PED] ASC,
		[STATUS] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]
END

GO

IF NOT EXISTS (SELECT * FROM SYS.DEFAULT_CONSTRAINTS WHERE NAME = 'DF_EST_PED_VD_ENVIO_PENDENTE_CD_EMP')
BEGIN
	ALTER TABLE [dbo].[EST_PED_VD_ENVIO_PENDENTE] ADD  CONSTRAINT [DF_EST_PED_VD_ENVIO_PENDENTE_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.DEFAULT_CONSTRAINTS WHERE NAME = 'DF_EST_PED_VD_ENVIO_PENDENTE_CD_FILIAL')
BEGIN
	ALTER TABLE [dbo].[EST_PED_VD_ENVIO_PENDENTE] ADD  CONSTRAINT [DF_EST_PED_VD_ENVIO_PENDENTE_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.DEFAULT_CONSTRAINTS WHERE NAME = 'DF_EST_PED_VD_ENVIO_PENDENTE_CD_PED')
BEGIN
	ALTER TABLE [dbo].[EST_PED_VD_ENVIO_PENDENTE] ADD  CONSTRAINT [DF_EST_PED_VD_ENVIO_PENDENTE_CD_PED]  DEFAULT ((0)) FOR [CD_PED]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE NAME = 'FK_EST_PED_VD_ENVIO_PENDENTE_EST_PED_VD')
BEGIN
	ALTER TABLE [dbo].[EST_PED_VD_ENVIO_PENDENTE]  WITH CHECK ADD  CONSTRAINT [FK_EST_PED_VD_ENVIO_PENDENTE_EST_PED_VD] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_PED])
	REFERENCES [dbo].[EST_PED_VD] ([CD_EMP], [CD_FILIAL], [CD_PED]) ON DELETE CASCADE

	ALTER TABLE [dbo].[EST_PED_VD_ENVIO_PENDENTE] CHECK CONSTRAINT [FK_EST_PED_VD_ENVIO_PENDENTE_EST_PED_VD]
END
GO


